/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class VWSplitPane
extends JSplitPane {
    private static final int BUFFER = 5;
    private static final int THRESHOLD = 10;
    private double m_proportionalLocation = 0.5;
    private boolean m_bFirstTime = true;

    public VWSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.orientation == 0) {
            if (height == 10) {
                height = this.getHeight();
            }
        } else if (width == 10) {
            height = this.getWidth();
        }
        super.setBounds(x, y, width, height);
        this.resetLayout();
    }

    public void setDividerLocation(int nLocation) {
        super.setDividerLocation(nLocation);
    }

    public void setDividerLocation(double proportionalLocation) {
        super.setDividerLocation(proportionalLocation);
        this.m_proportionalLocation = proportionalLocation;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            this.resetLayout();
        }
    }

    private void resetLayout() {
        this.calculateProportionalLocation();
        Rectangle leftRect = this.getBounds();
        Rectangle rightRect = new Rectangle(leftRect);
        if (this.orientation == 0) {
            leftRect.height = (int)((double)leftRect.height * this.m_proportionalLocation);
            rightRect.height -= leftRect.height;
        } else {
            leftRect.width = (int)((double)leftRect.width * this.m_proportionalLocation);
            rightRect.width -= leftRect.width;
        }
        JComponent panel = (JComponent)this.getLeftComponent();
        if (panel != null) {
            panel.setPreferredSize(new Dimension(leftRect.width - 5, leftRect.height - 5));
        }
        if ((panel = (JComponent)this.getRightComponent()) != null) {
            panel.setPreferredSize(new Dimension(rightRect.width - 5, rightRect.height - 5));
        }
        super.setDividerLocation(this.m_proportionalLocation);
    }

    private void calculateProportionalLocation() {
        Rectangle bounds = this.getBounds();
        if (bounds.isEmpty()) {
            return;
        }
        if (this.orientation == 0) {
            double dLocation;
            int nTotalHeight = bounds.height - this.getDividerSize();
            if (nTotalHeight > 0 && (dLocation = (double)this.getDividerLocation() / (double)nTotalHeight) >= 0.0 && dLocation <= 1.0) {
                this.m_proportionalLocation = dLocation;
            }
        } else {
            double dLocation;
            int nTotalWidth = bounds.width - this.getDividerSize();
            if (nTotalWidth > 0 && (dLocation = (double)this.getDividerLocation() / (double)nTotalWidth) >= 0.0 && dLocation <= 1.0) {
                this.m_proportionalLocation = dLocation;
            }
        }
    }
}

